#ifndef INKZ80
#include "z80.h"
#include "z80macros.h"
#else
#include "../cpcglob.h"
#endif
#include "../cpc.h"
/*---------------------------------------------------------*/
/* read a word from memory */
//#define Z80_RD_WORD(Addr) 	\
 ///   (Z80_WORD)((Z80_WORD)Z80_RD_BYTE(Addr) | (((Z80_WORD)Z80_RD_BYTE((Z80_WORD)(Addr+1)))<<8))
//#define Z80_RD_BYTE(Addr)	Z80_RD_MEM(Addr)

#if 0
Z80_WORD StepOutInstruction()
{
	/* Run to instruction after DJNZ? */


	return 0;
}
#endif

Z80_WORD GetJRDestination(MemoryRange *pRange)
{
    /* calc addr and go to it */
    Z80_BYTE_OFFSET Offset;

    Offset = (Z80_BYTE_OFFSET)MemoryRange_ReadByte(pRange, CPU_GetReg(CPU_PC)+1);

    return CPU_GetReg(CPU_PC) + (Z80_LONG)2 + Offset;
}

Z80_WORD GetRetDestination(MemoryRange *pRange)
{
    return MemoryRange_ReadWord(pRange, CPU_GetReg(CPU_SP));
}

Z80_WORD GetCallDestination(MemoryRange *pRange)
{
    return MemoryRange_ReadWord(pRange, CPU_GetReg(CPU_PC)+1);
}

Z80_WORD StepIntoInstruction(MemoryRange *pRange)
{
	/* get current instruction */
	int Instruction = MemoryRange_ReadByte(pRange, CPU_GetReg(CPU_PC));

	switch (Instruction)
	{
		/* DJNZ */
		case 0x010:
		{
			if (((CPU_GetReg(CPU_BC)>>8)&0x0ff)==1)
			{
				return CPU_GetReg(CPU_PC) + 2;
			}
			else
			{
			    return GetJRDestination(pRange);
			}
		}
		break;

		/* JR  */
		case 0x018:
		{
            return GetJRDestination(pRange);

		}
		break;

		/* JR NZ, */
		case 0x020:
		{
		    if (!CPU_GetFlag(CPU_FLAG_ZERO))
			{
				return GetJRDestination(pRange);
			}
		}
		break;

		/* JR Z, */
		case 0x028:
		{
		    if (CPU_GetFlag(CPU_FLAG_ZERO))
			{
				return GetJRDestination(pRange);
			}
		}
		break;


		/* JR NC */
		case 0x030:
		{
		    if (!CPU_GetFlag(CPU_FLAG_CARRY))
			{
				return GetJRDestination(pRange);
			}
		}
		break;

		/* JR C */
		case 0x038:
		{
		    if (CPU_GetFlag(CPU_FLAG_CARRY))
			{
				return GetJRDestination(pRange);
			}
		}
		break;

        /* HALT */
        case 0x076:
        {
            return CPU_GetReg(CPU_PC);
        }
        break;

        /* RET NZ */
		case 0x0c0:
		{
  		    if (!CPU_GetFlag(CPU_FLAG_ZERO))
				return GetRetDestination(pRange);
		}
		break;

        /* RET Z */
		case 0x0c8:
		{
  		    if (CPU_GetFlag(CPU_FLAG_ZERO))
				return GetRetDestination(pRange);
		}
		break;

		/* RET */
		case 0x0c9:
			return GetRetDestination(pRange);


		/* RET NC */
		case 0x0d0:
		{
 		    if (!CPU_GetFlag(CPU_FLAG_CARRY))
				return GetRetDestination(pRange);
		}
		break;

		/* RET C */
		case 0x0d8:
		{
 		    if (CPU_GetFlag(CPU_FLAG_CARRY))
				return GetRetDestination(pRange);
		}
		break;

		/* RET PO */
		case 0x0e0:
		{
 		    if (!CPU_GetFlag(CPU_FLAG_PARITYOVERFLOW))
				return GetRetDestination(pRange);
		}
		break;

		/* RET PE */
		case 0x0e8:
		{
 		    if (CPU_GetFlag(CPU_FLAG_PARITYOVERFLOW))
				return GetRetDestination(pRange);
		}
		break;

		/* RET P */
		case 0x0f0:
		{
            if (!CPU_GetFlag(CPU_FLAG_SIGN))
				return GetRetDestination(pRange);
		}
		break;

		/* RET M */
		case 0x0f8:
		{
            if (CPU_GetFlag(CPU_FLAG_SIGN))
				return GetRetDestination(pRange);
		}
		break;





		/* RST 0 */
		case 0x0c7:
			return 0x0;

		/* RST 8 */
		case 0x0cf:
			return 0x08;

		/* RST 10 */
		case 0x0d7:
			return 0x010;

		/* RST 18 */
		case 0x0df:
			return 0x018;

		/* RST 20 */
		case 0x0e7:
			return 0x020;

		/* RST 28 */
		case 0x0ef:
			return 0x028;

		/* RST 30 */
		case 0x0f7:
			return 0x030;

		/* RST 38 */
		case 0x0ff:
			return 0x038;


		/* JP (HL) */
		case 0x0e9:
			return CPU_GetReg(CPU_HL);

		case 0x0fd:
		case 0x0dd:
		{
			int Instruction2 = MemoryRange_ReadByte(pRange, CPU_GetReg(CPU_PC)+1);
			switch (Instruction2)
			{
				case 0x0e9:
				{
					if (Instruction==0x0dd)
						return CPU_GetReg(CPU_IX);

					return CPU_GetReg(CPU_IY);
				}
				break;

				default:
					break;
			}
		}
		break;




		case 0x0ed:
		{
			int Instruction2 = MemoryRange_ReadByte(pRange,CPU_GetReg(CPU_PC)+1);
			switch (Instruction2)
			{
                /* RETN, RETI*/
				case 0x045:
				case 0x04d:
				case 0x055:
				case 0x05d:
				case 0x065:
				case 0x06d:
				case 0x075:
				case 0x07d:
				{
					return MemoryRange_ReadWord(pRange,CPU_GetReg(CPU_SP));
				}
				break;

				/* ldir */
				/* cpir */
				/* inir */
				/* otir */
				/* lddr */
				/* cpdr */
				/* indr */
				/* otdr */
				case 0x0b0:
				case 0x0b1:
				case 0x0b2:
				case 0x0b3:
				case 0x0b8:
				case 0x0b9:
				case 0x0ba:
				case 0x0bb:
				{
				    if (CPU_GetReg(CPU_BC)!=1)
                    {
                        return CPU_GetReg(CPU_PC);
                    }

                    return CPU_GetReg(CPU_PC)+2;

				}
				break;

				default:
					break;
			}


		}
		break;

		/* CALL NZ,nnnn */
		case 0x0c4:
		{
            if (!CPU_GetFlag(CPU_FLAG_ZERO))
				return GetCallDestination(pRange);
		}
		break;

		/* CALL Z,nnnn */
		case 0x0cc:
		{
            if (CPU_GetFlag(CPU_FLAG_ZERO))
				return GetCallDestination(pRange);
		}
		break;

		/* CALL nc,nnnn */
		case 0x0d4:
		{
            if (!CPU_GetFlag(CPU_FLAG_CARRY))
				return GetCallDestination(pRange);
		}
		break;

		/* CALL C,nnnn */
		case 0x0dc:
		{
            if (CPU_GetFlag(CPU_FLAG_CARRY))
				return GetCallDestination(pRange);
		}
		break;

		/* CALL PO,nnnn */
		case 0x0e4:
		{
            if (!CPU_GetFlag(CPU_FLAG_PARITYOVERFLOW))
				return GetCallDestination(pRange);
		}
		break;


		/* CALL PE,nnnn */
		case 0x0ec:
		{
            if (CPU_GetFlag(CPU_FLAG_PARITYOVERFLOW))
				return GetCallDestination(pRange);
		}
		break;

		/* CALL P,nnnn */
		case 0x0f4:
		{
            if (!CPU_GetFlag(CPU_FLAG_SIGN))
				return GetCallDestination(pRange);
		}
		break;

		/* CALL M,nnnn */
		case 0x0fc:
		{
            if (CPU_GetFlag(CPU_FLAG_SIGN))
				return GetCallDestination(pRange);
		}
		break;

		/* CALL nnnn */
		case 0x0cd:
			return GetCallDestination(pRange);

		/* JP nnnn */
		case 0x0c3:
			return GetCallDestination(pRange);

        /* JP nz,nnnn */
		case 0x0c2:
		{
            if (!CPU_GetFlag(CPU_FLAG_ZERO))
				return GetCallDestination(pRange);
		}
		break;

        /* JP z,nnnn */
		case 0x0ca:
		{
            if (CPU_GetFlag(CPU_FLAG_ZERO))
				return GetCallDestination(pRange);
		}
		break;

		/* JP nc,nnnn */
		case 0x0d2:
		{
            if (!CPU_GetFlag(CPU_FLAG_CARRY))
				return GetCallDestination(pRange);
		}
		break;


		/* JP c,nnnn */
		case 0x0da:
		{
            if (CPU_GetFlag(CPU_FLAG_CARRY))
				return GetCallDestination(pRange);
		}
		break;

		/* JP PO,nnnn */
		case 0x0e2:
		{
           if (!CPU_GetFlag(CPU_FLAG_PARITYOVERFLOW))
				return GetCallDestination(pRange);
		}
		break;

		/* JP PE,nnnn */
		case 0x0EA:
		{
           if (CPU_GetFlag(CPU_FLAG_PARITYOVERFLOW))
				return GetCallDestination(pRange);
		}
		break;


		/* JP P,nnnn */
		case 0x0f2:
		{
           if (!CPU_GetFlag(CPU_FLAG_SIGN))
				return GetCallDestination(pRange);
		}
		break;

		/* JP M,nnnn */
		case 0x0fA:
		{
           if (CPU_GetFlag(CPU_FLAG_SIGN))
				return GetCallDestination(pRange);
		}
		break;

     default:
            break;

	}

	{
		int nBytes = Debug_GetOpcodeCount(pRange, CPU_GetReg(CPU_PC));
		return CPU_GetReg(CPU_PC)+nBytes;
	}
}

Z80_WORD StepOverInstruction(MemoryRange *pRange)
{
	/* get current instruction */
	int Instruction = MemoryRange_ReadByte(pRange,CPU_GetReg(CPU_PC));

	switch (Instruction)
	{
		/* JP (HL) */
		case 0x0e9:
			return CPU_GetReg(CPU_HL);

		case 0x0fd:
		case 0x0dd:
		{
			int Instruction2 = MemoryRange_ReadByte(pRange,CPU_GetReg(CPU_PC)+1);
			switch (Instruction2)
			{
				case 0x0e9:
				{
					if (Instruction==0x0dd)
						return CPU_GetReg(CPU_IX);

					return CPU_GetReg(CPU_IY);
				}
				break;

				default:
					break;
			}
		}
		break;


		/* JR  */
		case 0x018:
		{
			return GetJRDestination(pRange);
		}
		break;

		// do we want to follow? potentially no
#if 0
		/* JR NZ, */
		case 0x020:
		{
			if ((CPU_GetReg(CPU_F) & Z80_ZERO_FLAG)==0)
			{
				/* calc addr and go to it */
				Z80_BYTE_OFFSET Offset;

				Offset = (Z80_BYTE_OFFSET)Z80_RD_MEM(Z80_GetReg(Z80_PC)+1);

				return Z80_GetReg(Z80_PC) + (Z80_LONG)2 + Offset;
			}
		}
		break;

		/* JR Z, */
		case 0x028:
		{
			if ((CPU_GetReg(CPU_F) & Z80_ZERO_FLAG)!=0)
			{
				/* calc addr and go to it */
				Z80_BYTE_OFFSET Offset;

				Offset = (Z80_BYTE_OFFSET)Z80_RD_MEM(Z80_GetReg(Z80_PC)+1);

				return Z80_GetReg(Z80_PC) + (Z80_LONG)2 + Offset;
			}
		}
		break;


		/* JR NC */
		case 0x030:
		{
			if ((CPU_GetReg(CPU_F) & Z80_CARRY_FLAG)==0)
			{
				/* calc addr and go to it */
				Z80_BYTE_OFFSET Offset;

				Offset = (Z80_BYTE_OFFSET)Z80_RD_MEM(Z80_GetReg(Z80_PC)+1);

				return Z80_GetReg(Z80_PC) + (Z80_LONG)2 + Offset;
			}
		}
		break;

		/* JR C */
		case 0x038:
		{
			if ((CPU_GetReg(CPU_F) & Z80_CARRY_FLAG)!=0)
			{
				/* calc addr and go to it */
				Z80_BYTE_OFFSET Offset;

				Offset = (Z80_BYTE_OFFSET)Z80_RD_MEM(Z80_GetReg(Z80_PC)+1);

				return Z80_GetReg(Z80_PC) + (Z80_LONG)2 + Offset;
			}
		}
		break;
#endif
		/* RETN, RETI*/
		case 0x0ed:
		{
			Z80_BYTE Instruction2 = MemoryRange_ReadByte(pRange,CPU_GetReg(CPU_PC)+1);
			switch (Instruction2)
			{
				case 0x045:
				case 0x04d:
				case 0x055:
				case 0x05d:
				case 0x065:
				case 0x06d:
				case 0x075:
				case 0x07d:
				{
					return MemoryRange_ReadWord(pRange,CPU_GetReg(CPU_SP));
				}
				break;

				default:
					break;
			}


		}
		break;

#if 0
        /* RET NZ */
		case 0x0c0:
		{
			if ((CPU_GetReg(CPU_F) & Z80_ZERO_FLAG)==0)
				return Z80_RD_WORD(Z80_GetReg(Z80_SP));
		}
		break;

        /* RET Z */
		case 0x0c8:
		{
			if ((CPU_GetReg(CPU_F) & Z80_ZERO_FLAG)!=0)
				return Z80_RD_WORD(Z80_GetReg(Z80_SP));
		}
		break;
#endif
		/* RET */
		case 0x0c9:
			return MemoryRange_ReadWord(pRange,CPU_GetReg(CPU_SP));

#if 0
		/* RET NC */
		case 0x0d0:
		{
			if ((CPU_GetReg(CPU_F) & Z80_CARRY_FLAG)==0)
				return Z80_RD_WORD(Z80_GetReg(Z80_SP));
		}
		break;

		/* RET C */
		case 0x0d8:
		{
			if ((CPU_GetReg(CPU_F) & Z80_CARRY_FLAG)!=0)
				return Z80_RD_WORD(Z80_GetReg(Z80_SP));
		}
		break;

		/* RET PO */
		case 0x0e0:
		{
			if ((CPU_GetReg(CPU_F) & Z80_PARITY_FLAG)==0)
				return Z80_RD_WORD(Z80_GetReg(Z80_SP));
		}
		break;

		/* RET PE */
		case 0x0e8:
		{
			if ((CPU_GetReg(CPU_F) & Z80_PARITY_FLAG)!=0)
				return Z80_RD_WORD(Z80_GetReg(Z80_SP));
		}
		break;

		/* RET P */
		case 0x0f0:
		{
			if ((CPU_GetReg(CPU_F) & Z80_SIGN_FLAG)==0)
				return Z80_RD_WORD(Z80_GetReg(Z80_SP));
		}
		break;

		/* RET M */
		case 0x0f8:
		{
			if ((CPU_GetReg(CPU_F) & Z80_SIGN_FLAG)!=0)
				return Z80_RD_WORD(Z80_GetReg(Z80_SP));
		}
		break;
#endif
		/* JP nnnn */
		case 0x0c3:
			return GetRetDestination(pRange);
#if 0
    /* JP nz,nnnn */
		case 0x0c2:
		{
			if ((CPU_GetReg(CPU_F) & Z80_ZERO_FLAG)==0)
				return GetCallDestination(pRange);
		}
		break;

        /* JP z,nnnn */
		case 0x0ca:
		{
			if ((CPU_GetReg(CPU_F) & Z80_ZERO_FLAG)!=0)
				return GetCallDestination(pRange);
		}
		break;


		/* JP nc,nnnn */
		case 0x0d2:
		{
			if ((CPU_GetReg(CPU_F) & Z80_CARRY_FLAG)==0)
				return GetCallDestination(pRange);
		}
		break;


		/* JP c,nnnn */
		case 0x0da:
		{
			if ((CPU_GetReg(CPU_F) & Z80_CARRY_FLAG)!=0)
				return GetCallDestination(pRange);
		}
		break;

		/* JP PO,nnnn */
		case 0x0e2:
		{
			if ((CPU_GetReg(CPU_F) & Z80_PARITY_FLAG)==0)
				return GetCallDestination(pRange);
		}
		break;

		/* JP PE,nnnn */
		case 0x0EA:
		{
			if ((CPU_GetReg(CPU_F) & Z80_PARITY_FLAG)!=0)
				return GetCallDestination(pRange);
		}
		break;


		/* JP P,nnnn */
		case 0x0f2:
		{
			if ((CPU_GetReg(CPU_F) & Z80_SIGN_FLAG)==0)
				return GetCallDestination(pRange);
		}
		break;

		/* JP M,nnnn */
		case 0x0fA:
		{
			if ((CPU_GetReg(CPU_F) & Z80_SIGN_FLAG)!=0)
				return GetCallDestination(pRange);
		}
		break;
#endif
        default:
            break;


	}

	{
		int nBytes = Debug_GetOpcodeCount(pRange,CPU_GetReg(CPU_PC));
		return CPU_GetReg(CPU_PC)+nBytes;
	}
}

// get address after current opcode and run to that address?
